/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import xerca.xercamusic.common.Mod;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.item.ItemMusicSheet;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.packets.clientbound.ImportMusicPacket;
import xerca.xercamusic.common.packets.clientbound.MusicDataResponsePacket;

public class CommandImport {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"musicimport").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(p -> CommandImport.musicImport((class_2168)p.getSource(), StringArgumentType.getString((CommandContext)p, (String)"name")))));
    }

    private static int musicImport(class_2168 stack, String name) {
        Mod.LOGGER.debug("Music import called. name: {}", (Object)name);
        ImportMusicPacket pack = new ImportMusicPacket(name);
        try {
            class_3222 player = stack.method_9207();
            Mod.sendToClient(player, pack);
        }
        catch (CommandSyntaxException e) {
            Mod.LOGGER.debug("Command executor is not a player");
            e.printStackTrace();
            return 0;
        }
        return 1;
    }

    public static void doImport(class_2487 tag, ArrayList<NoteEvent> notes, class_3222 player) {
        if (tag.method_10573("author", 8) && !tag.method_10573("title", 8) || !tag.method_10573("author", 8) && tag.method_10573("title", 8)) {
            player.method_43496((class_2561)class_2561.method_43471((String)"xercamusic.import.fail.5").method_27692(class_124.field_1061));
            Mod.LOGGER.warn("Broken sheet file");
            return;
        }
        if (tag.method_10573("title", 8) && tag.method_10558("title").length() > 16) {
            tag.method_10582("title", tag.method_10558("title").substring(0, 16));
        }
        if (tag.method_10573("author", 8) && tag.method_10558("author").length() > 16) {
            tag.method_10582("author", tag.method_10558("author").substring(0, 16));
        }
        if (!tag.method_10573("ver", 3)) {
            tag.method_10569("ver", 1);
        }
        if (tag.method_10550("generation") > 0) {
            tag.method_10569("generation", tag.method_10550("generation") + 1);
        }
        if (tag.method_10545("id") && tag.method_10545("ver")) {
            id = tag.method_25926("id");
            int ver = tag.method_10550("ver");
            if (notes == null && (notes = MusicManager.getFinishedNotesFromBuffer(id)) == null) {
                return;
            }
            MusicManager.setMusicData(id, ver, notes, player.field_13995);
            MusicDataResponsePacket packet = new MusicDataResponsePacket(id, ver, notes);
            Mod.sendToClient(player, packet);
        } else if (tag.method_10545("music")) {
            Mod.LOGGER.info("Old music file version");
            notes = ItemMusicSheet.convertFromOld(tag, player.field_13995);
            id = tag.method_25926("id");
            int ver = tag.method_10550("ver");
            MusicDataResponsePacket packet = new MusicDataResponsePacket(id, ver, notes);
            Mod.sendToClient(player, packet);
        } else {
            Mod.LOGGER.warn("Broken music file");
            return;
        }
        if (player.method_7337()) {
            class_1799 itemStack = new class_1799((class_1935)Items.MUSIC_SHEET);
            CommandImport.importIntoStack(itemStack, tag);
            player.method_7270(itemStack);
        } else {
            class_1799 mainHandItem = player.method_6047();
            if (!(mainHandItem.method_7909() instanceof ItemMusicSheet) || !ItemMusicSheet.isEmptySheet(mainHandItem)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"xercamusic.import.fail.1").method_27692(class_124.field_1061));
                return;
            }
            CommandImport.importIntoStack(mainHandItem, tag);
        }
        player.method_43496((class_2561)class_2561.method_43471((String)"xercamusic.import.success").method_27692(class_124.field_1060));
    }

    private static void importIntoStack(class_1799 sheet, class_2487 tag) {
        sheet.method_57379(Items.SHEET_ID, (Object)tag.method_25926("id"));
        sheet.method_57379(Items.SHEET_GENERATION, (Object)tag.method_10550("generation"));
        sheet.method_57379(Items.SHEET_VERSION, (Object)tag.method_10550("ver"));
        sheet.method_57379(Items.SHEET_LENGTH, (Object)tag.method_10550("l"));
        if (tag.method_10573("bps", 1)) {
            sheet.method_57379(Items.SHEET_BPS, (Object)tag.method_10571("bps"));
        }
        if (tag.method_10573("piLocked", 1)) {
            sheet.method_57379(Items.SHEET_PREV_INSTRUMENT_LOCKED, (Object)tag.method_10577("piLocked"));
        }
        if (tag.method_10573("prevIns", 1)) {
            sheet.method_57379(Items.SHEET_PREV_INSTRUMENT, (Object)tag.method_10571("prevIns"));
        }
        if (tag.method_10573("title", 8) && tag.method_10573("author", 8)) {
            sheet.method_57379(Items.SHEET_TITLE, (Object)tag.method_10558("title"));
            sheet.method_57379(Items.SHEET_AUTHOR, (Object)tag.method_10558("author"));
        }
        if (tag.method_10573("hl", 1)) {
            sheet.method_57379(Items.SHEET_HIGHLIGHT_INTERVAL, (Object)tag.method_10571("hl"));
        }
        if (tag.method_10573("vol", 5)) {
            sheet.method_57379(Items.SHEET_VOLUME, (Object)Float.valueOf(tag.method_10583("vol")));
        }
    }
}

